(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     26894,        613]
NotebookOptionsPosition[     25817,        571]
NotebookOutlinePosition[     26180,        587]
CellTagsIndexPosition[     26137,        584]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
The Crystalfield theory package of Quanty for Mathematica contains the \
function AtomicRadialFunction, which reproduces the FPLO atomic DFT orbitals. \
With these orbitals one can relatively easy calculate the needed Slater \
integrals\
\>", "Text",
 CellChangeTimes->{{3.746718451070805*^9, 3.746718519691208*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Quanty`CrystalFieldTheory`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.746717774176517*^9, 3.7467177849338083`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Loaded the Quanty : Crystal Field Theory Package - version \
\"\>", "\[InvisibleSpace]", "\<\"2017.8.10\"\>"}],
  SequenceForm[
  "Loaded the Quanty : Crystal Field Theory Package - version ", "2017.8.10"],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.7467178743092813`*^9}],

Cell[BoxData["\<\"Written by Maurits W. Haverkort\"\>"], "Print",
 CellChangeTimes->{3.746717874312711*^9}]
}, Open  ]]
}, Open  ]],

Cell["Obtain the Radial function for the Ni 3 d orbital", "Text",
 CellChangeTimes->{{3.746718528801046*^9, 3.746718558200635*^9}, 
   3.746718610713048*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rnl", "=", 
  RowBox[{"AtomicRadialFunction", "[", 
   RowBox[{"\"\<Ni\>\"", ",", "3", ",", "2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7467178760710697`*^9, 3.7467179187753973`*^9}, 
   3.7467179999374847`*^9, 3.746718305551255*^9}],

Cell[BoxData[
 TagBox[
  TemplateBox[{RowBox[{
      StyleBox[
       TagBox["InterpolatingFunction", "SummaryHead"], 
       "NonInterpretableSummary"], 
      StyleBox["[", "NonInterpretableSummary"], 
      DynamicModuleBox[{Typeset`open$$ = False}, 
       PanelBox[
        PaneSelectorBox[{False -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquarePlusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = True), Appearance -> None,
                 Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{4.2372881355932373`*^-7, 
                    1.0494522203825785`*^-16}, {0.035124305899951955`, 
                    0.07229281630828824}}], 
                    LineBox[CompressedData["
1:eJwBQQO+/CFib1JlAgAAADMAAAACAAAAs8hzSx2WDkAqo8cxyIGyP2vAcTS4
9hBA/FZcVfLrqT9q4qf19JsSQOW6Z9JjWaI/B41eUOg4FEAgYQggFzWaPyRl
hBD2+BVAG+lcqbY3kj9vczOECJsXQIb7RUN3+Yk/Oq9RXTVgGUBHgH43JAGC
P6Nz8M8YHRtABL9eh08geT85bhj2ALwcQIk/jvV29XE/T5avgQN+HkBasJQX
K/JoP0r6Z2AFESBAGkoCoXy/YT8swK8ylvQgQNNjtYLWilg/Xcq3UQLUIUCg
UGcTNhVRP6RvhMpwpCJAiMIPTD9eSD+rqwh2bIYjQAs4VcIr5UA/yYJRe2pZ
JEDoXbgBUAI4PzaeWs1DKCVA+du7ppEtMT9jUBtSqggmQDtspP9Q5ic/p52g
MBPaJkB333Bi8gkhP6uB3UEJvSdA2yMOTrKfFz/+qdqf2psoQD538bEUfhA/
Z22cV65rKUCTEFzvRJkHP5DHFUIPTSpA2xVwowhrAD/QvFOGch8rQItnW4rt
aPc+X/ZRF7HtK0B2tZVvP87wPq7GB9t8zSxAdbBj/uV25z4TMoL4Sp4tQKDP
tKyUyOA+ODS0SKaALkDDoxHqrljXPnTRqvIDVC9AOMYqdxmi0D6A2bB0nhEw
QGC1pKF32sc+phVoiQGCMECz8AR9tp3APlefAcvl6jBAOnqf4emstz5o9Pal
kFwxQMB7SRJBVbA+oWtMJynMMUA6odHO+oKmPmUwhNVCNDJA965tn3dhnz6J
wBcdI6UyQGc41DpYnpQ+OJ6NkYQOM0D/QL3/vYOKPg+eY6zTdTNAIggHY9yl
fz5GaZVg6eUzQBC50PfitG4+CIKpQYBONEB0rqCXWxFYPipmGbzdvzRAIUXu
1NJ3NT50bOncKC81QDMRP+npWAE+ScCbKvWWNUDUtProBcezPX7fqRGIBzZA
b+Pu/tpZLz0+TJolnHA2QGDf+tW2SYY8XoTm0nbiNkCoaUVntqoWvKbekiY/
UjdAP+AirNQXAzx5hiGniLo3QAAAAAAAAAAArPkLwZgrOEAAAAAAAAAAAGu6
2AcqlThAAAAAAAAAAABaGeT4//84QAAAAAAAAAAA80NgQA==
                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$3207#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 
                 25.0000000000001}, {-3.0719304263772714`*^-19, 
                 0.07229281630828824}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "25.0000000000001`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}], True -> GridBox[{{
              PaneBox[
               ButtonBox[
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEBitmaps", "SquareMinusIconMedium"]], 
                ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                None, Evaluator -> Automatic, Method -> "Preemptive"], 
               Alignment -> {Center, Center}, ImageSize -> 
               Dynamic[{
                 Automatic, 3.5 CurrentValue["FontCapHeight"]/
                  AbsoluteCurrentValue[Magnification]}]], 
              GraphicsBox[{{{{}, {}, 
                  TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    
                    LineBox[{{4.2372881355932373`*^-7, 
                    1.0494522203825785`*^-16}, {0.035124305899951955`, 
                    0.07229281630828824}}], 
                    LineBox[CompressedData["
1:eJwBQQO+/CFib1JlAgAAADMAAAACAAAAs8hzSx2WDkAqo8cxyIGyP2vAcTS4
9hBA/FZcVfLrqT9q4qf19JsSQOW6Z9JjWaI/B41eUOg4FEAgYQggFzWaPyRl
hBD2+BVAG+lcqbY3kj9vczOECJsXQIb7RUN3+Yk/Oq9RXTVgGUBHgH43JAGC
P6Nz8M8YHRtABL9eh08geT85bhj2ALwcQIk/jvV29XE/T5avgQN+HkBasJQX
K/JoP0r6Z2AFESBAGkoCoXy/YT8swK8ylvQgQNNjtYLWilg/Xcq3UQLUIUCg
UGcTNhVRP6RvhMpwpCJAiMIPTD9eSD+rqwh2bIYjQAs4VcIr5UA/yYJRe2pZ
JEDoXbgBUAI4PzaeWs1DKCVA+du7ppEtMT9jUBtSqggmQDtspP9Q5ic/p52g
MBPaJkB333Bi8gkhP6uB3UEJvSdA2yMOTrKfFz/+qdqf2psoQD538bEUfhA/
Z22cV65rKUCTEFzvRJkHP5DHFUIPTSpA2xVwowhrAD/QvFOGch8rQItnW4rt
aPc+X/ZRF7HtK0B2tZVvP87wPq7GB9t8zSxAdbBj/uV25z4TMoL4Sp4tQKDP
tKyUyOA+ODS0SKaALkDDoxHqrljXPnTRqvIDVC9AOMYqdxmi0D6A2bB0nhEw
QGC1pKF32sc+phVoiQGCMECz8AR9tp3APlefAcvl6jBAOnqf4emstz5o9Pal
kFwxQMB7SRJBVbA+oWtMJynMMUA6odHO+oKmPmUwhNVCNDJA965tn3dhnz6J
wBcdI6UyQGc41DpYnpQ+OJ6NkYQOM0D/QL3/vYOKPg+eY6zTdTNAIggHY9yl
fz5GaZVg6eUzQBC50PfitG4+CIKpQYBONEB0rqCXWxFYPipmGbzdvzRAIUXu
1NJ3NT50bOncKC81QDMRP+npWAE+ScCbKvWWNUDUtProBcezPX7fqRGIBzZA
b+Pu/tpZLz0+TJolnHA2QGDf+tW2SYY8XoTm0nbiNkCoaUVntqoWvKbekiY/
UjdAP+AirNQXAzx5hiGniLo3QAAAAAAAAAAArPkLwZgrOEAAAAAAAAAAAGu6
2AcqlThAAAAAAAAAAABaGeT4//84QAAAAAAAAAAA80NgQA==
                    "]]}, 
                   Annotation[#, 
                    "Charting`Private`Tag$3207#1"]& ]}}, {}, {}}, {
               DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                AxesOrigin -> {0, 0}, 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, DisplayFunction -> Identity, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                All, DisplayFunction -> Identity, AspectRatio -> 1, 
                Axes -> {False, False}, AxesLabel -> {None, None}, 
                AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                Frame -> {{True, True}, {True, True}}, 
                FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                Directive[
                  Opacity[0.5], 
                  Thickness[Tiny], 
                  RGBColor[0.368417, 0.506779, 0.709798]], 
                FrameTicks -> {{None, None}, {None, None}}, 
                GridLines -> {None, None}, GridLinesStyle -> Directive[
                  GrayLevel[0.5, 0.4]], ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}], 
                Method -> {
                 "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                  AbsolutePointSize[6], "ScalingFunctions" -> None, 
                  "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}}, 
                PlotRange -> {{0., 
                 25.0000000000001}, {-3.0719304263772714`*^-19, 
                 0.07229281630828824}}, PlotRangeClipping -> True, 
                PlotRangePadding -> {{
                   Scaled[0.1], 
                   Scaled[0.1]}, {
                   Scaled[0.1], 
                   Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
              GridBox[{{
                 RowBox[{
                   TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "25.0000000000001`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"scalar\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["3", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                 RowBox[{
                   TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                   "\[InvisibleSpace]", 
                   TagBox["False", "SummaryItem"]}]}}, 
               GridBoxAlignment -> {
                "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
               False, GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
               BaseStyle -> {
                ShowStringCharacters -> False, NumberMarks -> False, 
                 PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
            GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            BaselinePosition -> {1, 1}]}, 
         Dynamic[Typeset`open$$], ImageSize -> Automatic], BaselinePosition -> 
        Baseline], DynamicModuleValues :> {}], 
      StyleBox["]", "NonInterpretableSummary"]}]},
   "CopyTag",
   DisplayFunction->(#& ),
   InterpretationFunction->("InterpolatingFunction[{{0., 25.}}, <>]"& )],
  False,
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{{3.7467178882836237`*^9, 3.746717919564789*^9}, 
   3.7467180012029943`*^9}]
}, Open  ]],

Cell["Plot the function", "Text",
 CellChangeTimes->{{3.746718528801046*^9, 3.746718558200635*^9}, {
  3.746718610713048*^9, 3.746718620734515*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Rnl", "[", "r", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7467179534819937`*^9, 3.746717960743842*^9}, 
   3.746718007847569*^9, 3.7467183074606323`*^9, {3.7467185650167923`*^9, 
   3.746718599665512*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVlnc41e8fxu1khaOhiPpWIilNCvdHKkV8S1bSQFn5KipSlFKJKGRlj7LK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       "]]},
     Annotation[#, "Charting`Private`Tag$7008#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 5}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.746717961229083*^9, 3.74671800832821*^9, {3.746718568262638*^9, 
   3.746718600090774*^9}}]
}, Open  ]],

Cell["\<\
The function is normalized. (note that we use the radial function times r)\
\>", "Text",
 CellChangeTimes->{{3.746718528801046*^9, 3.746718558200635*^9}, {
  3.746718610713048*^9, 3.7467186490154963`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Rnl", "[", "r", "]"}], "2"], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.746717965505126*^9, 3.7467180129209337`*^9}, 
   3.746718309141794*^9}],

Cell[BoxData["0.9999998917645087`"], "Output",
 CellChangeTimes->{{3.746717994661405*^9, 3.74671801334914*^9}}]
}, Open  ]],

Cell["Calculate the Slater integrals in units of eV", "Text",
 CellChangeTimes->{{3.746718528801046*^9, 3.746718558200635*^9}, {
  3.746718610713048*^9, 3.7467186661840887`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Hartree", "=", "27.2114"}], ";"}]], "Input",
 CellChangeTimes->{{3.746718369474393*^9, 3.7467183765246162`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Hartree", " ", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"Min", "[", 
          RowBox[{"r1", ",", "r2"}], "]"}], "k"], 
        SuperscriptBox[
         RowBox[{"Max", "[", 
          RowBox[{"r1", ",", "r2"}], "]"}], 
         RowBox[{"k", "+", "1"}]]], 
       SuperscriptBox[
        RowBox[{"Rnl", "[", "r1", "]"}], "2"], 
       SuperscriptBox[
        RowBox[{"Rnl", "[", "r2", "]"}], "2"]}], ",", 
      RowBox[{"{", 
       RowBox[{"r1", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"r2", ",", "0", ",", "10"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "4"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.746718036637195*^9, 3.746718096243816*^9}, {
  3.746718310972888*^9, 3.7467183368925953`*^9}, {3.7467183806647453`*^9, 
  3.7467183810230923`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "25.449681647131786`", ",", "11.45086759936056`", ",", 
   "7.066706194044164`"}], "}"}]], "Output",
 CellChangeTimes->{3.746718064854198*^9, 3.746718338491049*^9, 
  3.74671838278903*^9}]
}, Open  ]]
},
WindowSize->{1188, 951},
WindowMargins->{{-1327, Automatic}, {50, Automatic}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 326, 6, 49, "Text"],
Cell[CellGroupData[{
Cell[909, 30, 159, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[1093, 36, 332, 8, 24, "Print"],
Cell[1428, 46, 107, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[1562, 51, 157, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[1744, 57, 261, 5, 32, "Input"],
Cell[2008, 64, 13746, 277, 61, "Output"]
}, Open  ]],
Cell[15769, 344, 148, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[15942, 350, 596, 16, 32, "Input"],
Cell[16541, 368, 6976, 127, 248, "Output"]
}, Open  ]],
Cell[23532, 498, 215, 4, 30, "Text"],
Cell[CellGroupData[{
Cell[23772, 506, 297, 8, 35, "Input"],
Cell[24072, 516, 111, 1, 32, "Output"]
}, Open  ]],
Cell[24198, 520, 178, 2, 30, "Text"],
Cell[24379, 524, 147, 3, 32, "Input"],
Cell[CellGroupData[{
Cell[24551, 531, 1017, 29, 58, "Input"],
Cell[25571, 562, 230, 6, 32, "Output"]
}, Open  ]]
}
]
*)

